import { useEffect, useContext } from 'react';
import { useDispatch } from 'react-redux';
import { XivaContext, XivaBackendEventType, XivaBackendEvents } from 'modules/xiva';
import { ETypeString } from 'types/entities';
import { ReduxContext } from '../../redux';

export const TimelineXivaUpdateSpy = ({ issueId }) => {
  const xiva = useContext(XivaContext);
  const redux = useContext(ReduxContext);
  const dispatch = useDispatch();

  useEffect(() => {
    const handle = (event: XivaBackendEvents[XivaBackendEventType.IssueTimelineUpdate]) => {
      if (issueId !== event.detail.issueId) {
        return;
      }

      dispatch(redux.slices.storageSlice.actions.updateFromTimelineV2Data(event.detail));
    };
    const topic = `${ETypeString.Issue}@${issueId}`;

    xiva.addTopic(topic);
    xiva.addEventListener(XivaBackendEventType.IssueTimelineUpdate, handle);
    return () => {
      xiva.removeTopic(topic);
      xiva.removeEventListener(XivaBackendEventType.IssueTimelineUpdate, handle);
    };
  }, [issueId]);

  return null;
};
