// TODO: https://st.yandex-team.ru/CRM-10202
import React, { PureComponent } from 'react';
import ButtonToggle from 'lego/components/ButtonToggle';
import { PropsType } from './TogglePreviewButton.types';

export default class TogglePreviewButton extends PureComponent<PropsType> {
  public render() {
    const { isOpen, toggleAction, entityName = 'письмо' } = this.props;
    return (
      <ButtonToggle onClick={toggleAction} view="clear" size="xs" open={isOpen}>
        {isOpen ? `Свернуть ${entityName}` : `Развернуть ${entityName}`}
      </ButtonToggle>
    );
  }
}
