// TODO: https://st.yandex-team.ru/CRM-10202
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import CommentWF from 'forms/Comment/CommentWF';

interface State {
  isInvitees: boolean;
}

interface Dispatch {
  onSubmit: (values: object) => unknown;
}

interface Props {
  objId?: number;
  showSendAndOpenButton?: boolean;
  [key: string]: unknown;
}

export default withReduxContext<Props>(
  connect<State, Dispatch, Props & InjectedReduxContextProps>(
    (state, props: Props) => ({
      isInvitees: true,
      sendAndOpenButton: props.showSendAndOpenButton,
    }),
    (dispatch, props) => ({
      onSubmit: (values) =>
        dispatch(
          props.redux.slices.timelineSlice.asyncActions.commentSave({
            issueId: props.issueId,
            commentId: props.objId,
            ...values,
          }),
        ),
    }),
    (stateProps, dispatchProps, ownProps) => ({ ...stateProps, ...dispatchProps, ...ownProps }),
  )(CommentWF),
);
