import { LoadMailData, Comment, ChatMessage } from '../types';

export enum CommunicationTypes {
  Comment = 'comment',
  Mail = 'mail',
  Message = 'message',
  InternalMessage = 'internalMessage',
}

export interface InputRef {
  reply: (text: string) => void;
}

export interface CommunicationProps {
  issueId: number;
  className?: string;
  showCommentForm?: boolean;
  showMailForm?: boolean;
  showMessageForm?: boolean;
  showInternalMessageForm?: boolean;
  canCommentSendAndOpen?: boolean;
  isPristineCommentForm?: boolean;
  isPristineMailForm?: boolean;
  comType?: string;
  forceUseFeatureIssueTimelineV2?: boolean;
}

export interface MailConfig {
  type: string;
  loadArgs: unknown;
  isInternalMail?: boolean;
}

export interface CommunicationState {
  hash: number;
  isForceMountNextState: boolean;
  totalSubTasks: number;
  tab: CommunicationTypes | undefined;
  loadMailData: LoadMailData;
  pristine: boolean;
  comment?: Comment;
  message?: ChatMessage;
  internalMessage?: ChatMessage;
  showForm?: boolean;
  containerId?: number;
}
