// TODO: https://st.yandex-team.ru/CRM-10202
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import Comment from 'forms/Comment/Comment';
import {
  InternalMessageFormDispatchProps,
  InternalMessageFormProps,
} from './InternalMessageForm.types';

export const InternalMessageForm = withReduxContext<InternalMessageFormProps>(
  connect<
    {},
    InternalMessageFormDispatchProps,
    InternalMessageFormProps & InjectedReduxContextProps
  >(
    null,
    (dispatch, props) => ({
      onSubmit: (values) =>
        dispatch(
          props.redux.slices.timelineSlice.asyncActions.internalMessageSave({
            issueId: props.issueId,
            messageId: props.objId,
            ...values,
          }),
        ),
    }),
    (stateProps, dispatchProps, { redux, ...ownProps }) => ({ ...dispatchProps, ...ownProps }),
  )(Comment),
);
