// TODO: https://st.yandex-team.ru/CRM-10202
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import Comment from 'forms/Comment/Comment';
import * as React from 'react';
import { useContext, useEffect, useRef } from 'react';
import { useFactorStream } from 'services/FactorService/FactorService';
import { FormApi } from 'final-form';
import { MessageFormDispatchProps, MessageFormProps } from './MessageForm.types';
import { MessageFileInputContext } from '../../FileInputContext';
import { updateAttachedFiles, updateMessageText } from './MessageForm.utils';

// TODO: CRM-15491 разобраться с типами
export const MessageForm: React.FC<never> = (props) => {
  const factorStream = useFactorStream();
  const messageFileInputRef = useContext(MessageFileInputContext);
  const formApiRef = useRef<FormApi<unknown>>();
  const controlRef = useRef<HTMLInputElement>();

  useEffect(() => {
    if (!factorStream) {
      return;
    }

    const subscription = factorStream.subscribe((event) => {
      const factor = event?.payload;

      if (!event || !factor) {
        return;
      }

      if (messageFileInputRef.current && event.type === 'add') {
        updateAttachedFiles(factor, messageFileInputRef.current);
      }

      if (formApiRef.current && (event.type === 'add' || event.type === undefined)) {
        if (!controlRef.current) {
          return;
        }

        const selectionStart = controlRef.current?.selectionStart ?? 0;
        const selectionEnd = controlRef.current?.selectionEnd ?? 0;

        updateMessageText(factor, formApiRef.current, { selectionStart, selectionEnd });
      }
    });

    return () => {
      subscription.unsubscribe();
    };
  }, [factorStream, messageFileInputRef]);

  return (
    <Comment
      {...props}
      formApiRef={formApiRef}
      fileInputRef={messageFileInputRef}
      controlRef={controlRef}
    />
  );
};

export default withReduxContext<MessageFormProps>(
  connect<{}, MessageFormDispatchProps, MessageFormProps & InjectedReduxContextProps>(
    null,
    (dispatch, props) => ({
      onSubmit: (values) =>
        dispatch(
          props.redux.slices.timelineSlice.asyncActions.messageSave({
            issueId: props.issueId,
            messageId: props.objId,
            ...values,
          }),
        ),
    }),
    (stateProps, dispatchProps, { redux, ...ownProps }) => ({ ...dispatchProps, ...ownProps }),
  )(MessageForm),
);
