import { FormApi } from 'final-form';
import { FactorFile } from 'modules/upsale';
import { FactorData } from 'services/FactorService/FactorService';
import { FileInputApi } from '../../FileInputContext';

interface Selection {
  selectionStart: number;
  selectionEnd: number;
}

export const insertString = (original: string, inserted: string, selection: Selection) => {
  const { selectionStart, selectionEnd } = selection;

  return original.slice(0, selectionStart) + inserted + original.slice(selectionEnd);
};

export const updateAttachedFiles = (factor: FactorData, fileInputApi: FileInputApi) => {
  const attachedFiles = fileInputApi.getCurrentFiles() ?? [];
  const factorFiles = factor.files ?? [];

  const filesToLink: FactorFile[] = factorFiles.filter(
    (file) => !attachedFiles.find((attached) => attached.name === file.name),
  );

  if (!filesToLink.length) {
    return;
  }

  fileInputApi.updateFiles(
    filesToLink.map((file) => file.id),
    [],
  );
};

export const updateMessageText = (
  factor: FactorData,
  formApi: FormApi<unknown>,
  selection: Selection,
) => {
  const currentText = formApi.getFieldState('text')?.value ?? '';

  const newText = insertString(currentText, factor.templateText ?? '', selection);

  formApi.change('text', newText);
};
