// TODO: https://st.yandex-team.ru/CRM-10202
import Bluebird from 'bluebird';
import { Subject } from 'components/NewMailForm/NewMailForm.types';
import { baseCallApi } from 'api/common';
import { LoadMailData } from './types';
import { ModuleBackendMapping } from '../../types';

interface LoadMailResponse {
  mailReply: {
    froms?: string[];
    isExternalRecipients?: boolean;
    isHtml?: boolean;
    subject?: string;
    subjects?: Subject[];
  };
}

interface LoadTemplateResponse {
  // TODO: add types
  signatures: unknown[];
  templates: unknown[];
}

type MailRequest = (data: LoadMailData) => Bluebird<LoadMailResponse>;
type TemplatesRequest = (data: LoadMailData) => Bluebird<LoadTemplateResponse>;

export const loadDraft: MailRequest = (data) =>
  baseCallApi({
    url: '/actions/issue/mail/draft',
    data,
    global: false,
  });

export const reply: MailRequest = (data) =>
  baseCallApi({
    url: '/actions/issue/mail/reply',
    data,
    global: false,
  });

export const newMail: MailRequest = (data) =>
  baseCallApi({
    url: '/actions/issue/mail/new',
    data,
    global: false,
  });

const loadMailApiMap: { [key: string]: MailRequest } = {
  draft: loadDraft,
  reply: reply,
  new: newMail,
};

export const loadTemplates: TemplatesRequest = (data) =>
  baseCallApi({
    url: '/view/mail/template/list',
    data,
    global: false,
  });

export const loadMail = async (data) => {
  const load = loadMailApiMap[data.type] || loadMailApiMap.new;

  const [mail, templates] = await Bluebird.all([
    load(data),
    loadTemplates({ ...data, location: ModuleBackendMapping[data.location] }),
  ]);
  const { mailReply } = mail;
  const { froms = [], isHtml, subjects = [], ...mailRest } = mailReply;

  return {
    froms,
    subjects,
    initialValues: mailRest,
    ...templates,
  };
};
