import { ETypeString } from 'types/entities';
import { Action } from '../../Timeline/Item';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItem } from '../TimelineV2.types';
import { createMailActions } from './createMailActions';
import { createCommentActions } from './createCommentActions';
import { createMessageActions } from './createMessageActions';
import { createInternalMessageActions } from './createInternalMessageActions';

const ETypeToActionsCreator = {
  [ETypeString.Mail]: createMailActions,
  [ETypeString.OComment]: createCommentActions,
  [ETypeString.ChatMessage]: createMessageActions,
  [ETypeString.InternalChatMessage]: createInternalMessageActions,
} as const;

export const createAnyActions = (
  options: CreateActionsOptions<VirtualListTimelineItem>,
): Action[] => {
  const createActions = ETypeToActionsCreator[options.data.etype];

  return createActions ? createActions(options) : [];
};
