import { jsonApiCall } from 'api/common';
import { isEditAccess } from '../utils/validateAccess';
import { Action } from '../../Timeline/Item';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItemComment } from '../TimelineV2.types';

export const createCommentActions = (
  options: CreateActionsOptions<VirtualListTimelineItemComment>,
): Action[] => {
  const { data, communicationFormRef, issueId, maxAccess } = options;
  const access = data.data.props;

  const actions: Action[] = [];

  if (isEditAccess(access.canReply, maxAccess)) {
    actions.push({
      key: 'reply',
      onClick: () => communicationFormRef.current?.replyByComment(data.data.data.text),
      children: 'Ответить',
    });
  }

  if (isEditAccess(access.access, maxAccess)) {
    actions.push({
      key: 'edit',
      onClick: () => communicationFormRef.current?.editComment(data.data.data),
      children: 'Редактировать',
    });
  }

  if (isEditAccess(access.access, maxAccess)) {
    actions.push({
      key: 'remove',
      onClick: () => {
        if (window.confirm('Вы уверены, что хотите удалить этот комментарий?')) {
          jsonApiCall({
            url: '/issue/timeline/comment/delete',
            data: { data: { issueId, commentId: data.eid } },
          });
        }
      },
      children: 'Удалить',
    });
  }

  return actions;
};
