import { isEditAccess } from '../utils/validateAccess';
import { Action } from '../../Timeline/Item';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItemInternalChatMessage } from '../TimelineV2.types';

export const createInternalMessageActions = (
  options: CreateActionsOptions<VirtualListTimelineItemInternalChatMessage>,
): Action[] => {
  const { data, communicationFormRef, maxAccess } = options;
  const access = data.data.props;

  const actions: Action[] = [];

  if (isEditAccess(access.access, maxAccess)) {
    actions.push({
      key: 'edit',
      onClick: () => communicationFormRef.current?.editInternalMessage(data.data.data),
      children: 'Редактировать',
    });
  }

  return actions;
};
