import { config } from 'services/Config';
import { isEditAccess } from '../utils/validateAccess';
import { Action } from '../../Timeline/Item';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItemChatMessage } from '../TimelineV2.types';
import { deleteMessage } from '../utils/timelineItemApi';

export const createMessageActions = (
  options: CreateActionsOptions<VirtualListTimelineItemChatMessage>,
): Action[] => {
  const { data, communicationFormRef, issueId, maxAccess } = options;
  const access = data.data.props;

  const actions: Action[] = [];

  if (!config.value.features.newMessageControls) {
    //CRM-18544:
    return [];
  }

  if (isEditAccess(access.access, maxAccess)) {
    actions.push({
      key: 'edit',
      onClick: () => communicationFormRef.current?.editMessage(data.data.data),
      children: 'Редактировать',
    });
  }

  if (isEditAccess(access.access, maxAccess)) {
    actions.push({
      key: 'remove',
      onClick: () => {
        if (window.confirm('Вы уверены, что хотите удалить это сообщение?')) {
          deleteMessage(issueId, data.eid);
        }
      },
      children: 'Удалить',
    });
  }

  return actions;
};
