import React, { FC, useContext } from 'react';
import { Call as CallDTO } from 'types/entities/call';
import { TimelineCall } from 'components/TimelineCall';
import { useGlobalAudioContext } from 'modules/audio';
import { TimelineItemProps } from '../types/TimelineItemProps';
import { IssueIdContext } from '../../Issue/IssueIdContext';

export type CallProps = TimelineItemProps<CallDTO>;

export const Call: FC<CallProps> = (props) => {
  const {
    data,
    upsaleFactors,
    sideActions,
    mainActions,
    beforeContent,
    linkToTimelineItem,
    highlight,
    tags,
    itemId,
    showTags = false,
  } = props;
  const { author, dt } = data;
  const audio = useGlobalAudioContext();
  const issueId = useContext(IssueIdContext);

  return (
    <TimelineCall
      date={dt}
      activityId={itemId}
      author={author}
      audio={audio}
      call={data}
      showTags={showTags}
      tags={tags}
      mainActions={mainActions}
      sideActions={sideActions}
      beforeContent={beforeContent}
      metaCacheClearKey={issueId.toString()}
      dateUrl={linkToTimelineItem}
      highlight={highlight}
      upsaleFactors={upsaleFactors}
    />
  );
};
