import { Category, Categorization } from 'types/entities/categorization';

const getCategoryNameById = (categories: Category[], id: string) => {
  return categories.find((category) => String(category.id) === id)?.fullName;
};

export const getCategories = ({ selectedCategories, categories }: Categorization) => {
  const ids = Object.keys(selectedCategories);

  return ids.map((id) => ({
    id,
    name: getCategoryNameById(categories, id),
  }));
};
