import React, { FC } from 'react';
import { ChatMessage as ChatMessageDTO } from 'types/ChatMessage';
import { TimelineItem } from 'components/TimelineItem';
import Comment from 'components/Comment';
import Icon from 'lego/components/Icon';
import { TimelineItemProps } from '../types/TimelineItemProps';

export type ChatMessageProps = TimelineItemProps<ChatMessageDTO>;

export const ChatMessage: FC<ChatMessageProps> = (props) => {
  const { data, className, beforeContent, mainActions, highlight, linkToTimelineItem } = props;
  const { author, createdOn } = data;

  return (
    <TimelineItem
      highlight={highlight}
      dateUrl={linkToTimelineItem}
      className={className}
      author={author}
      date={createdOn}
      icon={<Icon pack={Icon.PACKS.MATERIAL} icon="message" />}
      actions={mainActions}
    >
      {beforeContent}
      <Comment comment={{ ...data, isHtml: false }} />
    </TimelineItem>
  );
};
