import React, { FC, Suspense } from 'react';
import { Comment as CommentDTO } from 'types/Comment';
import { TimelineItem } from 'components/TimelineItem';
import { Comment as CommentST } from 'modules/startrek';
import Icon from 'lego/components/Icon';
import { TimelineItemProps } from '../types/TimelineItemProps';

export type CommentProps = TimelineItemProps<CommentDTO>;

export const Comment: FC<CommentProps> = (props) => {
  const { data, className, beforeContent, mainActions, highlight, linkToTimelineItem } = props;
  const { author, dt, invitees } = data;

  return (
    <TimelineItem
      highlight={highlight}
      dateUrl={linkToTimelineItem}
      className={className}
      author={author}
      date={dt}
      icon={<Icon pack={Icon.PACKS.MATERIAL} icon="comment" />}
      afterAuthorName={<CommentST.Invitees invitees={invitees} />}
      actions={mainActions}
    >
      {beforeContent}
      <Suspense fallback={<span />}>
        <CommentST comment={data} contentOnly />
      </Suspense>
    </TimelineItem>
  );
};
