import React, { Component } from 'react';
import { formatTimelineDate } from 'modules/timeline/formatTimelineDate';
import { injectIntl } from 'react-intl';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import { WrappedComponentProps } from 'react-intl';
import cx from 'classnames';
import { DividerProps } from './Divider.types';
import css from './Divider.module.css';

const i18n = createI18N(commonKeyset);
const i18nToday = i18n('today');

type DividerInnerProps = DividerProps & WrappedComponentProps;

class DividerComponent extends Component<DividerInnerProps> {
  private getDivider(date?: string, prevDate?: string): string | null {
    if (!date) {
      return null;
    }

    const formattedDate = formatTimelineDate(date, this.props.intl.formatDate, i18nToday);
    if (
      !prevDate ||
      formatTimelineDate(prevDate, this.props.intl.formatDate, i18nToday) !== formattedDate
    ) {
      return formattedDate;
    }

    return null;
  }

  public render() {
    const { date, prevDate, className } = this.props;
    const divider = this.getDivider(date, prevDate);

    if (divider == null) {
      return null;
    }

    return <div className={cx(css.Divider, className)}>{divider}</div>;
  }
}

export const Divider = injectIntl(DividerComponent) as React.ComponentType<DividerProps>;
