import { makeObservable, observable, action } from 'mobx';
import { ListItemProvider } from 'types/ListItemProvider';
import {
  VirtualListItemId,
  VirtualListItem,
  VirtualListDataProvider,
  VirtualListGetOptions,
} from 'types/VirtualList';
import { VirtualListTimelineItem } from './TimelineV2.types';

export class IssueListDataProviderService<Item extends VirtualListItem = VirtualListTimelineItem>
  implements ListItemProvider<VirtualListItemId, Item>, VirtualListDataProvider<Item> {
  private store = new Map<VirtualListItemId, Item>();

  constructor(private virtualListDataProvider: VirtualListDataProvider<Item>) {
    makeObservable<IssueListDataProviderService<Item>, 'store' | 'updateItems'>(this, {
      store: observable,
      updateItems: action,
      setItemById: action,
    });
  }

  async get(options: VirtualListGetOptions) {
    const data = await this.virtualListDataProvider.get(options);

    this.updateItems(data.data);

    return data;
  }

  getMeta() {
    return this.virtualListDataProvider.getMeta();
  }

  getItemById(id: VirtualListItemId) {
    return this.store.get(id);
  }

  setItemById(id: VirtualListItemId, item: Item) {
    this.store.set(id, item);
  }

  private updateItems(items: Item[]) {
    items.forEach((itemJson) => {
      this.setItemById(itemJson.id, itemJson);
    });
  }
}
