import { ETypeString } from 'types/entities';
import {
  VirtualListTimelineItem,
  VirtualListTimelineItemComment,
  VirtualListTimelineItemMail,
  VirtualListTimelineItemCall,
  VirtualListTimelineItemChatMessage,
  VirtualListTimelineItemInternalChatMessage,
} from '../TimelineV2.types';

const etypeToDescriptionCreator = {
  [ETypeString.OComment]: (item: VirtualListTimelineItemComment) => {
    const date = new Date(item.data.data.dt);
    return `Комментарий от ${date.toLocaleDateString('ru')}, ${date.toLocaleTimeString('ru', {
      hour: '2-digit',
      minute: '2-digit',
    })}`;
  },
  [ETypeString.ChatMessage]: (item: VirtualListTimelineItemChatMessage) => {
    const date = new Date(item.data.data.createdOn);
    return `Сообщение от ${date.toLocaleDateString('ru')}, ${date.toLocaleTimeString('ru', {
      hour: '2-digit',
      minute: '2-digit',
    })}`;
  },
  [ETypeString.InternalChatMessage]: (item: VirtualListTimelineItemInternalChatMessage) => {
    const date = new Date(item.data.data.createdOn);
    return `Сообщение от ${date.toLocaleDateString('ru')}, ${date.toLocaleTimeString('ru', {
      hour: '2-digit',
      minute: '2-digit',
    })}`;
  },
  [ETypeString.YcCall]: (item: VirtualListTimelineItemCall) => {
    const date = new Date(item.data.data.dt);
    return `${item.data.data.direction.name} звонок от ${date.toLocaleDateString(
      'ru',
    )}, ${date.toLocaleTimeString('ru', {
      hour: '2-digit',
      minute: '2-digit',
    })}`;
  },
  [ETypeString.Mail]: (item: VirtualListTimelineItemMail) => {
    const date = new Date(item.data.data.date);
    return `Письмо от ${date.toLocaleDateString('ru')}, ${date.toLocaleTimeString('ru', {
      hour: '2-digit',
      minute: '2-digit',
    })}`;
  },
};

export const createDescription = (item?: VirtualListTimelineItem) => {
  if (!item || !item.data || !item.data.data) {
    return '';
  }

  const creator = etypeToDescriptionCreator[item.etype];

  if (!creator) {
    return `Has no description for etype: ${item.etype}`;
  }

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return creator(item as any);
};
