import React, { FC } from 'react';
import cx from 'classnames';
import { UpsaleFactorsComponent } from 'components/UpsaleFactors';
import { TimelineItem } from 'components/TimelineItem';
import { Mail as MailDTO } from 'types/Mail';
import MailBase from 'components/Mail';
import Icon from 'lego/components/Icon';
import css from '../../Timeline/Mail/Mail.module.css';
import { mapColor } from '../../Timeline/Mail/Mail.utils';
import { DIRECTION_ICON } from '../../Timeline/Mail/Mail.constants';
import { TimelineItemProps } from '../types/TimelineItemProps';

export type MailProps = TimelineItemProps<MailDTO>;

export const Mail: FC<MailProps> = (props): React.ReactElement => {
  const { data, className, beforeContent, mainActions, highlight, linkToTimelineItem } = props;
  const { type, date, author, hasAttach, isExternal, upsaleFactors } = data;

  const color = mapColor({
    isExternal,
    type,
  });

  return (
    <TimelineItem
      highlight={highlight}
      dateUrl={linkToTimelineItem}
      className={cx(css.b__mailPreview, className)}
      author={author}
      date={date}
      color={color}
      icon={<Icon pack={Icon.PACKS.MATERIAL} icon="mail" />}
      side={
        <>
          {DIRECTION_ICON[type]}
          {hasAttach && <Icon pack={Icon.PACKS.MATERIAL} icon="attach_file" />}
        </>
      }
      actions={mainActions}
    >
      {beforeContent}
      <MailBase key={date} {...data} className={css.b__mail} />
      <UpsaleFactorsComponent factors={upsaleFactors} />
    </TimelineItem>
  );
};
