import React, { FC, useContext } from 'react';
import { TimelineMeeting } from 'components/TimelineMeeting';
import { MeetingProps } from './Meeting.types';
import { issueTimelineItemContext } from '../issueTimelineItemContext';
import { SimpleTimelineItem } from '../TimelineV2.types';

export const Meeting: FC<MeetingProps> = (props) => {
  const { data, className, itemId } = props;
  const { dataProvider } = useContext(issueTimelineItemContext);
  const access = (dataProvider.getItemById(itemId) as SimpleTimelineItem)?.data?.props?.access || 1;

  return <TimelineMeeting className={className} id={data.id} meeting={data} editAccess={access} />;
};
