import { ETypeString } from 'types/entities';
import { Action } from 'components/TimelineItem2';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItem } from '../TimelineV2.types';
import { createMailSideActions } from './createMailSideActions';
import { createCommentSideActions } from './createCommentSideActions';
import { createMessageSideActions } from './createMessageSideActions';
import { createCallSideActions } from './createCallSideActions';

const ETypeToSideActionsCreator = {
  [ETypeString.Mail]: createMailSideActions,
  [ETypeString.OComment]: createCommentSideActions,
  [ETypeString.ChatMessage]: createMessageSideActions,
  [ETypeString.YcCall]: createCallSideActions,
} as const;

export const createAnySideActions = (
  options: CreateActionsOptions<VirtualListTimelineItem>,
): Action[] => {
  const createSideActions = ETypeToSideActionsCreator[options.data.etype];

  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return createSideActions ? createSideActions(options as any) : [];
};
