import React from 'react';
import { Action } from 'components/TimelineItem2';
import { isEditAccess, isReadAccess } from '../utils/validateAccess';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItemCall } from '../TimelineV2.types';
import { Categorization } from '../Categorization';

export const createCallSideActions = (
  options: CreateActionsOptions<VirtualListTimelineItemCall>,
): Action[] => {
  const { data, onCategorizationClick, maxAccess } = options;
  const access = data.data.props;

  const sideActions: Action[] = [];

  if (isEditAccess(access.category, maxAccess)) {
    sideActions.push({
      render: () => (
        <Categorization
          key="categorization"
          onClick={onCategorizationClick}
          categorization={data.data.categorization}
          alignment={data.alignment}
          isRequireMarkup={isReadAccess(access.isRequireMarkup, maxAccess)}
        />
      ),
    });
  }

  return sideActions;
};
