import React from 'react';
import { Action } from 'components/TimelineItem2';
import { isEditAccess, isReadAccess } from '../utils/validateAccess';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItemChatMessage } from '../TimelineV2.types';
import { Categorization } from '../Categorization';

export const createMessageSideActions = (
  options: CreateActionsOptions<VirtualListTimelineItemChatMessage>,
): Action[] => {
  const { data, onCategorizationClick, maxAccess } = options;
  const access = data.data.props;

  const sideActions: Action[] = [];

  if (isEditAccess(access.category, maxAccess)) {
    sideActions.push({
      render: () => (
        <Categorization
          key="categorization"
          onClick={onCategorizationClick}
          categorization={data.data.categorization}
          alignment={data.alignment}
          isRequireMarkup={
            Boolean(access.isRequireMarkup) && isReadAccess(access.isRequireMarkup!, maxAccess)
          }
        />
      ),
    });
  }

  return sideActions;
};
