import { ETypeString } from 'types/entities';
import { StatusActions } from 'components/TimelineItem2';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItem } from '../TimelineV2.types';
import { createMessageStatusActions } from './createMessageStatusActions';

const ETypeToStatusActionsCreator = {
  [ETypeString.ChatMessage]: createMessageStatusActions,
};

export const createAnyStatusActions = (
  options: CreateActionsOptions<VirtualListTimelineItem>,
): StatusActions => {
  const createStatusActions = ETypeToStatusActionsCreator[options.data.etype];

  return createStatusActions ? createStatusActions(options) : {};
};
