import { StatusActions } from 'components/TimelineItem2';
import { TimelineItemStatus } from 'types/TimelineItemStatus';
import { config } from 'services/Config';
import { isEditAccess } from '../utils/validateAccess';
import { CreateActionsOptions } from '../types/ActionItemScheme';
import { VirtualListTimelineItemChatMessage } from '../TimelineV2.types';
import { resendMessage, deleteMessage } from '../utils/timelineItemApi';

export const createMessageStatusActions = (
  options: CreateActionsOptions<VirtualListTimelineItemChatMessage>,
): StatusActions => {
  const { data, issueId, maxAccess } = options;
  const access = data.data.props;

  return {
    [TimelineItemStatus.Failed]: {
      tooltip: 'Ошибка отправки',
      actions:
        config.value.features.newMessageControls && isEditAccess(access.access, maxAccess)
          ? [
              {
                key: 'resend',
                onClick: () => {
                  resendMessage(issueId, data.eid);
                },
                children: 'Отправить снова',
              },
              {
                key: 'remove',
                onClick: () => {
                  deleteMessage(issueId, data.eid);
                },
                children: 'Отменить',
              },
            ]
          : [],
    },
  };
};
