import { RefObject } from 'react';
import { VirtualListService, VirtualListItem, VirtualListItemId } from 'types/VirtualList';
import { ListItemProvider } from 'types/ListItemProvider';
import { VirtualListProps } from 'components/VirtualList';
import { EType } from 'types/EType';
import { ETypeString } from 'types/entities';
import { TimelineCommentItem } from 'types/TimelineCommetItem';
import { TimelineChatMessageItem } from 'types/TimelineChatMessageItem';
import { TimelineMailItem } from 'types/TimelineMailItem';
import { TimelineCallItem } from 'types/TimelineCallItem';
import { TimelineItemAlignment } from 'types/TimelineItemAlignment';
import { TimelineGenericItem } from 'types/TimelineGenericItem';
import { TimelineItemError } from './types/TimelineItemError';
import { CommunicationForm } from './types/CommunicationForm';

export interface VirtualListTimelineItemGeneric<Type extends EType, Data> extends VirtualListItem {
  etype: Type;
  eid: number;
  data: Data;
  error?: TimelineItemError;
  backgroundColor?: string;
  alignment?: TimelineItemAlignment;
  createdOn: string;
}

export type VirtualListTimelineItemMail = VirtualListTimelineItemGeneric<
  typeof ETypeString.Mail,
  TimelineMailItem
>;
export type VirtualListTimelineItemComment = VirtualListTimelineItemGeneric<
  typeof ETypeString.OComment,
  TimelineCommentItem
>;
export type VirtualListTimelineItemChatMessage = VirtualListTimelineItemGeneric<
  typeof ETypeString.ChatMessage,
  TimelineChatMessageItem
>;
export type VirtualListTimelineItemInternalChatMessage = VirtualListTimelineItemGeneric<
  typeof ETypeString.InternalChatMessage,
  TimelineChatMessageItem
>;
export type VirtualListTimelineItemCall = VirtualListTimelineItemGeneric<
  typeof ETypeString.YcCall,
  TimelineCallItem
>;

type TimelineManagerActivityItem = TimelineGenericItem<SimpleTimelineItem, unknown>;
export type VirtualListTimelineItemManagerActivity = VirtualListTimelineItemGeneric<
  typeof ETypeString.ManagerActivity,
  TimelineManagerActivityItem
>;

export type SimpleTimelineItem =
  | VirtualListTimelineItemMail
  | VirtualListTimelineItemComment
  | VirtualListTimelineItemChatMessage
  | VirtualListTimelineItemInternalChatMessage
  | VirtualListTimelineItemCall;

export type VirtualListTimelineItem = SimpleTimelineItem | VirtualListTimelineItemManagerActivity;

export interface TimelineV2Props
  extends Omit<VirtualListProps<VirtualListTimelineItem>, 'listService' | 'itemContent'> {
  listService: VirtualListService<VirtualListTimelineItem>;
  dataProvider: ListItemProvider<VirtualListItemId, VirtualListTimelineItem>;
  communicationFormRef: RefObject<CommunicationForm>;
  issueId: number;
  moduleName: string;
  timelineId?: string;
  maxAccess?: number;
  height?: number;
  afterContent?: React.ReactNode;
  view?: 'default' | 'categorization';
}

export interface TimelineV2IssueProps
  extends Omit<TimelineV2Props, 'listService' | 'communicationFormRef' | 'dataProvider'> {
  issueId: number;
  moduleName: string;
  timelineId?: string;
  forceUseFeatureIssueTimelineV2?: boolean;
  showCommentForm?: boolean;
  showMailForm?: boolean;
  showMessageForm?: boolean;
  showInternalMessageForm?: boolean;
}
