import { RefObject } from 'react';
import { VirtualListItemId } from 'types/VirtualList';
import { ListItemProvider } from 'types/ListItemProvider';
import { CommunicationForm } from './CommunicationForm';
import { VirtualListTimelineItem, TimelineV2Props } from '../TimelineV2.types';

export interface IssueTimelineItemContext extends Pick<TimelineV2Props, 'view' | 'maxAccess'> {
  issueId: number;
  timelineId?: string;
  moduleName: string;
  dataProvider: ListItemProvider<VirtualListItemId, VirtualListTimelineItem>;
  communicationFormRef: RefObject<CommunicationForm>;
}
