import { FlexNode } from './types';

export const newTimelineDescription: FlexNode = {
  component: 'Flex',
  props: {
    direction: 'column',
  },
  content: [
    {
      component: 'Flex',
      props: {
        style: {
          marginTop: '8px',
        },
      },
      content: [
        {
          component: 'IssueField',
          props: {
            width: 'max',
            wikiformatter: true,
            name: 'text',
            component: 'WFInput',
            previewComponent: 'PreviewWikiFormatter',
            editBtn: true,
            fieldProps: {
              maxHeight: 80,
            },
            previewProps: {
              placeholder: 'Описание задачи',
            },
          },
        },
      ],
    },
    {
      component: 'Flex',
      props: {
        style: {
          marginTop: '8px',
        },
      },
      content: [
        {
          component: 'IssueField',
          props: {
            width: 'max',
            name: 'tip',
            component: 'Tip',
          },
        },
      ],
    },
  ],
};
