import { FlexNode } from './types';

const scheme: FlexNode = {
  component: 'Flex',
  props: {
    max: true,
    fields: true,
    style: {
      alignItems: 'center',
    },
  },
  content: [
    {
      component: 'IssueField',
      props: {
        name: 'isDone',
        component: 'IssueDone',
      },
    },
    {
      component: 'IssueType',
      props: {
        size: 'xs',
        color: 'lightGray',
        hasPreview: true,
      },
    },
    {
      component: 'IssueField',
      props: {
        size: 'xs',
        color: 'gray',
        weight: 'bold',
        name: 'state',
        maxAccess: 1,
        component: 'TextInput',
        previewComponent: 'PreviewState',
      },
    },
    {
      component: 'IssueField',
      props: {
        width: 'max',
        stopPropagation: true,
        name: 'name',
        editByDblClick: true,
        component: 'TextInput',
      },
    },
    {
      component: 'IssueField',
      props: {
        size: 'xs',
        color: 'grey',
        maxAccess: 1,
        name: 'queue',
        component: 'TextInput',
        previewComponent: 'PreviewState',
      },
    },
    {
      component: 'Flex',
      props: {
        right: true,
        fields: true,
        style: {
          flexShrink: 0,
        },
      },
      content: [
        {
          component: 'IssueField',
          props: {
            stopPropagation: true,
            name: 'issueDt',
            icon: {
              pack: 'fontawesome',
              icon: 'calendar',
            },
            iconWithValue: false,
            component: 'Date',
            previewComponent: 'PreviewDate',
            fieldProps: {
              view: 'inline',
              initOnMount: true,
              autoFocus: true,
              time: true,
            },
            previewProps: {
              time: true,
            },
          },
        },
        {
          component: 'IssueField',
          props: {
            stopPropagation: true,
            name: 'deadlineDt',
            icon: {
              pack: 'fontawesome',
              icon: 'calendar',
            },
            iconWithValue: false,
            component: 'Date',
            previewComponent: 'PreviewDate',
            fieldProps: {
              view: 'inline',
              initOnMount: true,
              autoFocus: true,
            },
          },
        },
        {
          component: 'IssueField',
          props: {
            stopPropagation: true,
            name: 'owner',
            backendUpdateKey: 'ownerId',
            component: 'SuggestStaffInline2',
            previewComponent: 'PreviewStaff',
            fieldProps: {
              isSingleValue: true,
              autoFocus: true,
              view: 'inline',
              hideSuggestIfSingleValue: false,
            },
            previewProps: {
              zIndex: 999,
              theme: 'avatar',
              size: 'xs',
            },
          },
        },
      ],
    },
  ],
};

export default scheme;
