import { FlexNode } from './types';

const scheme: { common: FlexNode; main: FlexNode } = {
  common: {
    component: 'Flex',
    props: {
      direction: 'column',
    },
    content: [
      {
        component: 'Flex',
        content: {
          component: 'IssueParent',
          props: {
            name: 'parentIssue',
          },
        },
      },
      {
        component: 'Flex',
        props: {
          fields: true,
        },
        content: [
          {
            component: 'IssueField',
            props: {
              name: 'isDone',
              component: 'IssueDone',
            },
          },
          {
            component: 'Flex',
            props: {
              max: true,
              direction: 'column',
            },
            content: [
              {
                component: 'Flex',
                props: {
                  fields: true,
                },
                content: [
                  {
                    component: 'IssueField',
                    props: {
                      width: 'max',
                      size: 'l',
                      multiline: true,
                      name: 'name',
                      editByDblClick: true,
                      component: 'TextInput',
                    },
                  },
                  {
                    component: 'Flex',
                    props: {
                      right: true,
                      fields: true,
                    },
                    content: [
                      {
                        component: 'IssueField',
                        props: {
                          name: 'issueDt',
                          component: 'Date',
                          icon: {
                            pack: 'fontawesome',
                            icon: 'calendar',
                          },
                          iconWithValue: false,
                          previewComponent: 'PreviewDate',
                          fieldProps: {
                            view: 'inline',
                            initOnMount: true,
                            autoFocus: true,
                            time: true,
                          },
                          previewProps: {
                            time: true,
                          },
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          name: 'deadlineDt',
                          component: 'Date',
                          icon: {
                            pack: 'fontawesome',
                            icon: 'calendar',
                          },
                          iconWithValue: false,
                          previewComponent: 'PreviewDate',
                          fieldProps: {
                            view: 'inline',
                            initOnMount: true,
                            autoFocus: true,
                          },
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          name: 'owner',
                          backendUpdateKey: 'ownerId',
                          component: 'SuggestStaffInline2',
                          previewComponent: 'PreviewStaff',
                          fieldProps: {
                            isSingleValue: true,
                            autoFocus: true,
                            view: 'inline',
                            hideSuggestIfSingleValue: false,
                          },
                          previewProps: {
                            zIndex: 999,
                            theme: 'avatar',
                            size: 'xs',
                          },
                        },
                      },
                    ],
                  },
                ],
              },
              {
                component: 'Flex',
                props: {
                  style: {
                    marginTop: '2px',
                    flexWrap: 'wrap',
                  },
                },
                content: [
                  {
                    component: 'Flex',
                    props: {
                      fields: true,
                      style: {
                        alignItems: 'center',
                        flexWrap: 'wrap',
                      },
                    },
                    content: [
                      {
                        component: 'IssueType',
                        props: {
                          size: 's',
                          color: 'lightGray',
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          size: 'xs',
                          color: 'gray',
                          weight: 'bold',
                          name: 'state',
                          maxAccess: 1,
                          component: 'TextInput',
                          previewComponent: 'PreviewState',
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          size: 'xs',
                          name: 'account',
                          multiline: true,
                          icon: {
                            pack: 'material',
                            icon: 'account_circle',
                          },
                          editBtn: true,
                          editBtnTitle: 'Выбрать аккаунт',
                          removeBtnTitle: 'Удалить аккаунт',
                          remove: true,
                          backendUpdateKey: 'accountId',
                          component: 'AccountModal',
                          previewComponent: 'PreviewAccount',
                          previewProps: {
                            services: true,
                            size: 'small',
                          },
                        },
                      },
                    ],
                  },
                  {
                    component: 'Flex',
                    props: {
                      fields: true,
                      right: true,
                    },
                    content: [
                      {
                        component: 'IssueField',
                        props: {
                          name: 'quickPanel',
                          component: 'ButtonGroup',
                          fieldProps: {
                            view: 'pseudo',
                            asButton: true,
                          },
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          name: 'supportChat',
                          component: 'SupportChat',
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          stopPropagation: true,
                          size: 'xs',
                          name: 'timers',
                          component: 'Timers',
                        },
                      },
                      {
                        component: 'IssueField',
                        props: {
                          name: 'actions',
                          component: 'DropdownMenu',
                          fieldProps: {
                            theme: 'pseudo',
                            arrow: false,
                            asButton: true,
                            text: 'Действия',
                          },
                        },
                      },
                    ],
                  },
                ],
              },
            ],
          },
        ],
      },
      {
        component: 'Flex',
        props: {
          style: {
            margin: '8px 0 0',
          },
        },
        content: [
          {
            component: 'IssueField',
            props: {
              width: 'max',
              name: 'actionStateChange',
              component: 'ButtonGroup',
              fieldProps: {
                view: 'pseudo',
              },
            },
          },
        ],
      },
    ],
  },
  main: {
    component: 'Flex',
    props: {
      max: true,
      direction: 'column',
    },
    content: [
      {
        component: 'Flex',
        props: {
          style: {
            marginTop: '8px',
          },
        },
        content: [
          {
            component: 'IssueField',
            props: {
              width: 'max',
              wikiformatter: true,
              name: 'text',
              component: 'WFInput',
              previewComponent: 'PreviewWikiFormatter',
              editBtn: true,
              previewProps: {
                placeholder: 'Описание задачи',
              },
            },
          },
        ],
      },
      {
        component: 'Flex',
        props: {
          style: {
            marginTop: '8px',
          },
        },
        content: [
          {
            component: 'IssueField',
            props: {
              width: 'max',
              name: 'tags',
              component: 'IssueTags',
              fieldProps: {
                showAuthor: true,
              },
            },
          },
        ],
      },
      {
        component: 'Flex',
        props: {
          style: {
            marginTop: '8px',
          },
        },
        content: [
          {
            component: 'IssueField',
            props: {
              width: 'max',
              name: 'tip',
              component: 'Tip',
            },
          },
        ],
      },
    ],
  },
};

export default scheme;
