import { FlexNode } from '../types';

export const opportunitiesScheme: FlexNode = {
  component: 'Flex',
  props: {
    direction: 'column',
    max: true,
  },
  content: [
    {
      component: 'Flex',
      content: {
        component: 'IssueParent',
        props: {
          name: 'parentIssue',
        },
      },
    },
    {
      component: 'Flex',
      props: {
        max: true,
        fields: true,
      },
      content: [
        {
          component: 'IssueField',
          props: {
            name: 'isDone',
            component: 'IssueDone',
          },
        },
        {
          component: 'Flex',
          props: {
            max: true,
            direction: 'column',
          },
          content: [
            {
              component: 'Flex',
              props: {
                style: {
                  alignItems: 'center',
                },
              },
              content: [
                {
                  component: 'IssueField',
                  props: {
                    width: 'max',
                    name: 'name',
                    component: 'TextInput',
                    editByDblClick: true,
                  },
                },
                {
                  component: 'Flex',
                  props: {
                    right: true,
                    fields: true,
                    style: {
                      flexShrink: 0,
                    },
                  },
                  content: [
                    {
                      component: 'IssueField',
                      props: {
                        stopPropagation: true,
                        name: 'createdOn',
                        icon: {
                          pack: 'fontawesome',
                          icon: 'calendar',
                        },
                        iconWithValue: false,
                        component: 'Date',
                        previewComponent: 'PreviewDate',
                        fieldProps: {
                          view: 'inline',
                          initOnMount: true,
                          autoFocus: true,
                        },
                      },
                    },
                    {
                      component: 'IssueField',
                      props: {
                        stopPropagation: true,
                        name: 'owner',
                        backendUpdateKey: 'ownerId',
                        component: 'SuggestStaffInline2',
                        previewComponent: 'PreviewStaff',
                        fieldProps: {
                          isSingleValue: true,
                          autoFocus: true,
                          view: 'inline',
                          hideSuggestIfSingleValue: false,
                        },
                        previewProps: {
                          zIndex: 999,
                          theme: 'avatar',
                          size: 'xs',
                        },
                      },
                    },
                  ],
                },
              ],
            },
            {
              component: 'Flex',
              props: {
                style: {
                  marginTop: '2px',
                  alignItems: 'center',
                },
              },
              content: [
                {
                  component: 'Flex',
                  props: {
                    fields: true,
                    style: {
                      overflow: 'hidden',
                    },
                  },
                  content: [
                    {
                      component: 'IssueType',
                      props: {
                        size: 'xs',
                        color: 'lightGray',
                      },
                    },
                    {
                      component: 'IssueField',
                      props: {
                        size: 'xs',
                        color: 'gray',
                        weight: 'bold',
                        name: 'state',
                        maxAccess: 1,
                        component: 'TextInput',
                        previewComponent: 'PreviewState',
                      },
                    },
                    {
                      component: 'IssueField',
                      props: {
                        width: 'max',
                        size: 'xs',
                        maxAccess: 1,
                        icon: {
                          pack: 'material',
                          icon: 'account_circle',
                        },
                        name: 'account',
                        backendUpdateKey: 'accountId',
                        component: 'AccountModal',
                        previewComponent: 'PreviewAccount',
                      },
                    },
                  ],
                },
              ],
            },
            {
              component: 'Flex',
              props: {
                style: {
                  marginTop: '2px',
                },
              },
              content: [
                {
                  component: 'IssueField',
                  props: {
                    width: 'max',
                    size: 's',
                    color: 'grey',
                    maxAccess: 1,
                    name: 'opportunityCurrentAmount',
                    component: 'TextInput',
                    previewComponent: 'PreviewValue',
                    previewProps: {
                      contentPlaceholder: ' руб.',
                      contentPlaceholderWhenEmpty: false,
                    },
                  },
                },
              ],
            },
            {
              component: 'Flex',
              props: {
                style: {
                  marginTop: '2px',
                },
              },
              content: [
                {
                  component: 'IssueField',
                  props: {
                    width: 'max',
                    maxAccess: 1,
                    name: 'tags',
                    component: 'IssueFastTags',
                    fieldProps: {
                      size: 'xxs',
                      wrap: 'nowrap',
                    },
                  },
                },
              ],
            },
          ],
        },
      ],
    },
  ],
};
