import { IssueFieldSchemeProps } from '../../types';

type Content<T> = T | T[];

interface IssueFieldNode {
  component: 'IssueField';
  props: IssueFieldSchemeProps;
}

interface IssueTypeNode {
  component: 'IssueType';
  props?: {
    size?: string;
    color?: string;
    hasPreview?: boolean;
  };
}

interface IssueParentNode {
  component: 'IssueParent';
  props: {
    name: string;
  };
}

export interface FlexNode {
  component: 'Flex';
  props?: {
    max?: boolean;
    direction?: string;
    style?: any;
    fields?: boolean;
    right?: boolean;
  };
  content: Content<FlexNode | IssueFieldNode | IssueTypeNode | IssueParentNode>;
}
