import getRoutingRoot from 'utils/getRoutingRoot';
import { ModuleName, IssueType } from '../../types';

export default ({
  issueTypeId,
  issueId,
}: {
  issueTypeId: number | string;
  issueId: number | string;
}): string => {
  let parsedTypeId: number = issueTypeId as number;
  if (typeof issueTypeId === 'string') {
    // issueTypeId === '0', '1', ...
    parsedTypeId = parseInt(issueTypeId, 10);
  }

  let typeIdNumber: number = parsedTypeId;
  if (Number.isNaN(parsedTypeId)) {
    // issueTypeId === 'None', 'Task', ...
    typeIdNumber = IssueType[issueTypeId];
  }

  const root = getRoutingRoot();
  switch (typeIdNumber) {
    case 3: {
      return `${root}/${ModuleName.Ticket}/${issueId}`;
    }

    case 1: {
      return `${root}/${ModuleName.Issue}/${issueId}`;
    }

    case 6: {
      return `${root}/${ModuleName.Opportunities}/${issueId}`;
    }

    default: {
      return `${root}/`;
    }
  }
};
