import Access from 'utils/Access';
import { FieldProps } from 'types/Attributes';

// eslint-disable-next-line max-params
export default (eType, dataObject, props, redirect, dispatch, maxAccess) => {
  const { propsSlug, access, ...otherProps } = props;
  const { name } = props;

  const { id } = dataObject;

  const { access: backendAccess, ...otherBackendProps } = ((dataObject.props || {})[
    propsSlug || name
  ] || {}) as FieldProps;

  let resultAccess = access || backendAccess || 0;
  const resultMaxAccess = maxAccess || props.maxAccess;

  if (resultMaxAccess && Number.isInteger(resultMaxAccess)) {
    resultAccess = Math.min(resultAccess, resultMaxAccess);
  }

  if (!Access.isRead(resultAccess)) {
    return null;
  }

  return {
    value: dataObject.data[name],
    oId: {
      eId: id,
      eType,
    },
    access: resultAccess,
    redirect,
    dispatch,
    ...otherProps,
    fieldProps: {
      ...otherBackendProps,
      ...otherProps.fieldProps,
    },
  };
};
