export const sec2time = (timeInSeconds: number | undefined): string => {
  if (typeof timeInSeconds !== 'number') {
    return '';
  }
  const time = timeInSeconds;
  const hours = Math.floor(time / 60 / 60);
  const minutes = Math.floor(time / 60) % 60;
  const seconds = Math.floor(time - minutes * 60 - hours * 60 * 60);
  const result = [
    String(seconds).padStart(2, '0'),
    String(minutes).padStart(2, '0'),
    String(hours).padStart(2, '0'),
  ];
  return result.reverse().join(':');
};
