import { withReduxProvider } from './redux';
import Router from './components/Router';
import IssueList, { Props as IssueListProps } from './components/IssueList';
import Issue, { OwnProps as IssueProps } from './components/Issue/Issue';
import IssueModuleIcon from './components/ModuleIcon';

const IssueListWithProvider = withReduxProvider<IssueListProps>()(IssueList);
const IssueWithProvider = withReduxProvider<IssueProps>()(Issue);
const RouterWithProvider = withReduxProvider()(Router);

export { IssueListWithProvider as IssueList, IssueWithProvider as Issue, IssueModuleIcon };
export default RouterWithProvider;
