/* eslint-disable @typescript-eslint/no-explicit-any */
import Bluebird from 'bluebird';
import { jsonApiCall } from 'api/common';
import { CreateIssueBackendData, RequestData, ResponseData, RequestWithContext } from '../types';

interface IssueApiRequest {
  data: any;
  url: string;
}

export const issueApiRequest = <T>(options: IssueApiRequest): Bluebird<T> =>
  jsonApiCall({
    url: options.url,
    type: 'POST',
    global: false,
    data: options.data,
  });

interface GetIssueData {
  id: number;
}

export const getIssue = (data: RequestData<GetIssueData>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/get`,
    data,
  });

interface DeleteIssueData {
  id: number;
}

export const deleteIssue = (data: RequestData<DeleteIssueData>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/delete`,
    data,
  });

interface MutationIssueData {
  id: number;
  [key: string]: any;
}

export const mutationIssue = (data: RequestData<MutationIssueData>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/mutation`,
    data,
  });

export const linkIssue = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issues/link`,
    data,
  });

export const createStartrek = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/startrek/create`,
    data,
  });

export const linkStartrek = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/startrek/link`,
    data,
  });

export const unlinkStartrek = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/startrek/unlink`,
    data,
  });

export const detachMail = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/detachmail`,
    data,
  });

export const getIssues = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issues/get`,
    data,
  });

export const getStartrekIssues = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/startrek/list`,
    data,
  });

export const getFilters = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/nav/list`,
    data,
  });

export const getTimeline = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/timeline/get`,
    data,
  });

export const commentSave = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/timeline/comment/save`,
    data,
  });

export const commentDelete = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/timeline/comment/delete`,
    data,
  });

export const messageSave = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/timeline/message/save`,
    data,
  });

export const messageDelete = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/timeline/message/delete`,
    data,
  });

export const internalMessageSave = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/issue/timeline/internalmessage/save`,
    data,
  });

export const mailSend = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/actions/issue/mail/send`,
    data,
  });

export const mailDelete = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: '/actions/issue/mail/delete',
    data,
  });

export const mailSave = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/actions/issue/mail/save`,
    data,
  });

export const refresh = (data: RequestWithContext) =>
  issueApiRequest<ResponseData>({
    url: `/issues/refresh`,
    data,
  });

export const takeNextTicket = (data: RequestData<any>) =>
  issueApiRequest<ResponseData>({
    url: `/actions/issue/takenext`,
    data,
  });

export const printAttachments = (data: RequestData<{ mailId: string | number }>) =>
  issueApiRequest<ResponseData>({
    url: `/print/mail/${data.data.mailId}`,
    data,
  });

export interface CreateIssueData {
  name: string;
}

export interface CreateAccountIssueData extends CreateIssueData {
  accountId: number;
}

export type CreateIssueDataSome = CreateIssueData | CreateAccountIssueData | CreateIssueBackendData;

export const createIssue = (data: RequestData<CreateIssueDataSome>) =>
  issueApiRequest<ResponseData>({
    url: `/issues/create`,
    data,
  });
