import { issueApiRequest } from '../api';
import { ResponseData, RequestData } from '../../types';

export enum CallDirection {
  In = 1,
  Out = 2,
}

export enum CallStatus {
  InProgress = 1,
  End = 2,
}

export type SaveCallRequest = {
  id?: number;
  callId: string;
  operatorPhoneNumber?: string;
  direction: CallDirection;
  operatorId?: number;
  issueId: number;
  status: CallStatus;
  accountId?: number;
} & (
  | {
      kikId: number;
      direction: CallDirection.Out;
    }
  | {
      direction: CallDirection.In;
    }
);

export interface SaveCallResponse {
  id: number;
}

export const saveCall = (data: RequestData<SaveCallRequest>) =>
  issueApiRequest<ResponseData<SaveCallResponse>>({ url: '/issue/timeline/call/save', data });
