import { Request, RequestContext } from '../types';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
type AppThunk = any;

export interface ExtendRequest {
  contextExtend?: {
    main: {
      issue: {
        id: number;
      };
    };
  };
}

export default <Req = {}, Res = {}, P extends ExtendRequest = {}>(
  request: Request<Req, Res> | RequestContext<Res>,
  options,
) => {
  const { slices, selectors } = options;

  return (data: Req, extendRequest?: P): AppThunk => (dispatch, getState) => {
    const { contextExtend, ...other } = Object(extendRequest);

    let context = selectors.context(getState());
    if (contextExtend) {
      context = { ...context, ...contextExtend };
    }

    return request({ data, context, ...other }).then((response) => {
      if (response.storage) {
        dispatch(slices.storageSlice.actions.update(response.storage));
        dispatch(slices.storageSlice.asyncActions.updateModuleCounter(response.storage));
      }

      return response;
    });
  };
};
