import { Slice, Reducer } from '@reduxjs/toolkit';

interface Dictionary<S> {
  [key: string]: S;
}

export default <S extends Slice>(
  slice: S,
  slug: string = 'name',
): Reducer<Dictionary<ReturnType<S['reducer']>>> => (state = {}, action) => {
  if (!(typeof action.type === 'string' && action.type.startsWith(`${slice.name}/`))) {
    return state;
  }

  if (!action.meta) {
    return state;
  }

  const name = action.meta[slug];

  const itemState = state[name];
  const result = slice.reducer(itemState, action);
  return result === itemState ? state : { ...state, [name]: result };
};
