/* eslint-disable no-param-reassign  */

import { createSlice } from '@reduxjs/toolkit';
import { DEFAULT_FILTER, DEFAULT_SORT } from '../../constants';
import { ModuleName } from '../../types';

export const createInitialState = (module: ModuleName) => ({
  filters: {
    fast: DEFAULT_FILTER[module],
  },
  currentFilter: 'fast',
  sort: DEFAULT_SORT[module],
});

type AppThunk = any;

export default options => {
  const { name, slices } = options;

  const filterSlice = createSlice({
    name: `${name}/filter`,
    initialState: createInitialState(name),
    reducers: {
      set: (state, { payload }) => {
        return {
          ...state,
          filters: {
            ...state.filters,
            [payload.type]: {
              ...state.filters[payload.type],
              ...payload.data,
            },
          },
          currentFilter: payload.type,
        };
      },
      setSort: (state, { payload }) => {
        state.sort = payload;
      },
    },
    extraReducers: {
      LOCAL_STORAGE(state) {
        return state;
      },
    },
  });

  const setSort = (sort: string): AppThunk => dispatch => {
    dispatch(filterSlice.actions.setSort(sort));
    dispatch(
      slices.nodesSlice.asyncActions.get({
        nodeId: 'issueList.map.0',
        path: 'issueList',
      }),
    );
  };

  const setWithRefresh = (data: any): AppThunk => dispatch => {
    dispatch(filterSlice.actions.set(data));
    dispatch(
      slices.nodesSlice.asyncActions.get({
        nodeId: 'issueList.map.0',
        path: 'issueList',
      }),
    );
  };

  return {
    ...filterSlice,
    actions: {
      ...filterSlice.actions,
      setSort,
      setWithRefresh,
    },
  };
};
