/* eslint-disable no-param-reassign */
import { createSlice } from '@reduxjs/toolkit';
import { ModuleName } from 'modules/issues/types';
import { config } from 'services/Config';
import { refresh, takeNextTicket } from '../api';
import createAsyncAction from '../createAsyncAction';

export default (options) => {
  const { name } = options;

  const configMap = {
    [ModuleName.Issue]: config.value.config.configMap.Issue,
    [ModuleName.Ticket]: config.value.config.configMap.Ticket,
    [ModuleName.Opportunities]: config.value.config.configMap.Opportunity,
  };

  const moduleSlice = createSlice({
    name: `${name}/module`,
    initialState: configMap[name],
    reducers: {
      init: () => {
        return configMap[name];
      },
      destroy: (state) => state,
    },
  });

  return {
    ...moduleSlice,
    asyncActions: {
      refresh: createAsyncAction(refresh, options),
      takeNextTicket: createAsyncAction(takeNextTicket, options),
    },
  };
};
