import { createSlice } from '@reduxjs/toolkit';
import config from '../../components/Timeline/config';

export default options => {
  return createSlice({
    name: `${options.name}/timeline`,
    initialState: {
      sort: config.defaultSort,
    },
    reducers: {
      setSort(state, { payload }) {
        return {
          sort: payload,
        };
      },
    },
    extraReducers: {
      LOCAL_STORAGE(state) {
        return state;
      },
    },
  });
};
