/* eslint-disable no-param-reassign,@typescript-eslint/no-explicit-any */
import { createSlice } from '@reduxjs/toolkit';
import {
  getTimeline,
  commentDelete,
  commentSave,
  messageSave,
  internalMessageSave,
  messageDelete,
  mailSave,
  mailSend,
  mailDelete,
  printAttachments,
} from '../api';
import { saveCategory } from '../api/categorization';
import { saveCall } from '../api/callApi';
import createAsyncAction from '../createAsyncAction';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
type AppThunk = any;

const prepare = (id: number) => ({ payload: id, meta: { id } });

const withMeta = (reducer) => ({
  reducer,
  prepare,
});

export default (options) => {
  const { name, slices, selectors } = options;

  const issueSlice = createSlice({
    name: `${name}/timeline`,
    initialState: {
      isFetch: false,
      isLoad: false,
    },
    reducers: {
      getTimelineRequest: withMeta((state) => {
        state.isFetch = true;
      }),
      getTimelineSuccess: withMeta((state) => {
        state.isLoad = true;
        state.isFetch = false;
      }),
      getTimelineFailed: withMeta((state) => {
        state.isFetch = false;
      }),
    },
  });

  const { getTimelineRequest, getTimelineSuccess, getTimelineFailed } = issueSlice.actions;

  const fetchTimeline = (data: any = {}): AppThunk => async (dispatch, getState) => {
    const { issueId } = data;

    try {
      dispatch(getTimelineRequest(issueId));
      const response = await getTimeline({ data, context: selectors.context(getState()) });
      if (response.storage) {
        dispatch(slices.storageSlice.actions.update(response.storage));
        dispatch(slices.storageSlice.asyncActions.updateModuleCounter(response.storage));
      }
      dispatch(getTimelineSuccess(issueId));
    } catch (err) {
      dispatch(getTimelineFailed(issueId));
    }
  };

  return {
    ...issueSlice,
    asyncActions: {
      fetchTimeline,
      commentSave: createAsyncAction(commentSave, options),
      commentDelete: createAsyncAction(commentDelete, options),
      internalMessageSave: createAsyncAction(internalMessageSave, options),
      messageSave: createAsyncAction(messageSave, options),
      messageDelete: createAsyncAction(messageDelete, options),
      mailSave: createAsyncAction(mailSave, options),
      mailSend: createAsyncAction(mailSend, options),
      mailDelete: createAsyncAction(mailDelete, options),
      printAttachments: createAsyncAction(printAttachments, options),
      saveCall: createAsyncAction(saveCall, options),
      saveCategory: createAsyncAction(saveCategory, options),
    },
  };
};
