const DEEP_MERGE_KEY = 'nodes';

const deepMerge = (left, right) => {
  const result = { ...left };

  Object.keys(right).forEach(key => {
    if (key === 'map') {
      result[key] = { ...result[key], ...right[key] };
    } else {
      result[key] = deepMerge(result[key], right[key]);
    }
  });

  return result;
};

export default <S = {}>(left: any = Object(), right: any = Object()): S => {
  let result: any = null;
  Object.keys(right).forEach(key => {
    if (!result) {
      result = { ...left };
    }

    if (left[key]) {
      if (key === DEEP_MERGE_KEY) {
        result[key] = deepMerge(left[key], right[key]);
      } else {
        result[key] = { ...left[key], ...right[key] };
      }
    } else {
      result[key] = right[key];
    }
  });

  return result || left;
};
