import { get } from 'api/common';
import { CallMetaService } from 'modules/webphone/types';

export interface BackendQueueCallOptions {
  outgoingPhoneNumber: string;
  unitYaCallsId: string;
}

export class QueueService implements CallMetaService {
  private readonly queueId: number;

  constructor(queueId: number) {
    this.queueId = queueId;
  }

  public getCallMeta = () => {
    return get({
      url: `/queue/${this.queueId}/callOptions`,
    }).then((data: BackendQueueCallOptions) => ({
      caller: data.outgoingPhoneNumber,
      associatedUnitId: data.unitYaCallsId,
    }));
  };
}
