/* eslint-disable @typescript-eslint/no-explicit-any */
import React from 'react';
import Bluebird from 'bluebird';
import { Account } from 'types';
import { DataObject, FieldProps } from 'types/Attributes';

export interface RequestWithContext {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  context?: any;
}

export interface RequestData<T> extends RequestWithContext {
  data: T;
}

export interface StorageResponse {
  storage?: StorageData;
}

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export interface ResponseData<T = any> extends StorageResponse {
  data: T;
}

export type Request<Req, Res> = (data: RequestData<Req>) => Bluebird<ResponseData<Res>>;
export type RequestContext<Res> = (data: RequestWithContext) => Bluebird<ResponseData<Res>>;

export enum IssueType {
  None = 0,
  Task = 1,
  Event = 2,
  Ticket = 3,
  Request = 4,
  Approval = 5,
  Opportunities = 6,
}

export enum ModuleName {
  Issue = 'issues',
  Ticket = 'cases',
  Opportunities = 'opportunities',
}

export enum BackendModuleName {
  Issue = 'issue',
  Ticket = 'ticket',
  Opportunities = 'opportunity',
}

export const ModuleTitle = {
  [ModuleName.Ticket]: 'Тикет',
  [ModuleName.Issue]: 'Задача',
  [ModuleName.Opportunities]: 'Сделка',
};

export const ModuleBackendMapping = {
  [ModuleName.Issue]: 'issue',
  [ModuleName.Ticket]: 'ticket',
  [ModuleName.Opportunities]: BackendModuleName.Opportunities,
};

export interface DictionaryValue {
  id: number;
  name: string;
}

export interface FilterData {
  counter?: number;
  id: number;
  name: string;
  color: string;
  disabled: boolean;
}

export interface IssueData {
  account?: Account;
  author: unknown;
  createdOn: string;
  followers: unknown[];
  id: number;
  type: string;
  typeId: number;
  isDone: boolean;
  modifiedOn: string;
  name: string;
  number: number;
  queue?: {
    id: number;
    name: string;
  };
  category?: {
    id: number;
    name: string;
  };
  owner: unknown;
  tags: unknown[];
  tip?: {
    body: string;
    backgroundColor: string;
  };
  state: DictionaryValue;
  opportunityCurrentAmount: number;
  parentIssue?: {
    id: number;
    name: string;
    typeId: number;
  };
}

export interface FieldItem {
  val: string;
  text: string;
  alert: boolean;
  redirect: boolean;
}

export type FieldItemWithItems = FieldItem & { items?: FieldItem[] };

interface PossibleResolution {
  access: number;
  items: {
    val: string;
    text: string;
    alert: boolean;
    redirect: boolean;
  }[];
}

export interface IssueProps {
  accessEnterPin: FieldProps;
  account: FieldProps;
  actionDelete: FieldProps;
  actionStateChange: FieldProps;
  actions: FieldProps;
  author: FieldProps;
  commentEdit: FieldProps;
  comments: FieldProps;
  createdOn: FieldProps;
  deadlineDt: FieldProps;
  followers: FieldProps;
  id: FieldProps;
  isDone: FieldProps;
  mailDraftEdit: FieldProps;
  mails: FieldProps;
  chats: FieldProps;
  modifiedOn: FieldProps;
  name: FieldProps;
  number: FieldProps;
  owner: FieldProps;
  parentIssue: FieldProps;
  priority: FieldProps;
  resolution: FieldProps;
  state: FieldProps;
  subIssues: FieldProps;
  category: FieldProps;
  calls: FieldProps;
  tags: FieldProps;
  text: FieldProps;
  timeline: FieldProps;
  timerEdit: FieldProps;
  timers: FieldProps;
  type: FieldProps;
  workflow: FieldProps;
  upsale: FieldProps;
  contacts: FieldProps;
  possibleMailCloseResolution: PossibleResolution;
  commentSendAndOpen: FieldProps;
  mailSendAndClose: FieldProps;
  accountTasks: FieldProps;
  opportunityCurrentAmount: FieldProps;
  quickPanel: FieldProps;
  starTrekActions: FieldProps;
  takeIssue: FieldProps;
}

export interface IssueFieldSchemeProps {
  name: string;
  component: string;
  label?: React.ReactNode;
  width?: string;
  className?: string;
  color?: string;
  weight?: string;
  propsSlug?: string;
  context?: string;
  stopPropagation?: boolean;
  multiline?: boolean;
  access?: number;
  maxAccess?: number;
  iconWithValue?: boolean;
  wikiformatter?: boolean;
  size?: string;
  icon?: {
    pack: string;
    icon: string;
  };
  editBtn?: boolean;
  editBtnTitle?: string;
  removeBtnTitle?: string;
  editByDblClick?: boolean;
  remove?: boolean;
  backendUpdateKey?: string;
  previewComponent?: string;
  alert?: boolean;
  fieldProps?: {
    [key: string]: unknown;
  };
  previewProps?: {
    [key: string]: unknown;
  };
}

export interface AttributeProps {
  access: number;
  component: string;
  label: string;
  name: string;
  backendUpdateKey?: string;
  fieldProps?: {
    [key: string]: unknown;
  };
}

export interface SelectFieldProps {
  isSingleValue?: boolean; // если true то значение селекта один элемент, иначе массив
  items: { id: number; name: string }[];
  mode: 'radio' | 'check' | 'radiocheck';
}

export interface IssueScheme {
  attributes?: AttributeProps[];
}

export type IssueObject = DataObject<IssueData, IssueProps, IssueScheme>;

export interface StartrekData {
  createdOn: string;
  key: string;
  title: string;
  state: string;
  id: number;
}

export type StartrekObject = DataObject<StartrekData, undefined, {}>;

interface Dictionary<Value> {
  [key: number]: Value;
}

export interface Node {
  id: number;
  eof: boolean;
  items?: number[];
  counter: number;
  _sync: string;
}

type Nodes = {
  [key: number]: {
    counter: number;
    eof: boolean;
    id: number;
    _sync: string;
  };
} & {
  0: {
    counter: number;
    eof: boolean;
    id: number;
    items: number[];
  };
};

interface NodesMap {
  map?: Nodes;
}

interface IssueNodes {
  subIssues: NodesMap;
  blockedIssues: NodesMap;
  blockedByIssues: NodesMap;
  relatedIssues: NodesMap;
  duplicateIssues: NodesMap;
  originalIssues: NodesMap;
  timeline: NodesMap;
}

interface IssueNodes {
  subIssues: NodesMap;
  timeline: NodesMap;
}

interface AccountNodes {
  issues: NodesMap;
}

export interface StorageData {
  comments?: Dictionary<DataObject>;
  mails?: Dictionary<DataObject>;
  issueFilters?: Dictionary<FilterData>;
  issues?: Dictionary<IssueObject>;
  startrekIssues?: Dictionary<StartrekObject>;
  counters?: {
    issues?: {
      unread: number;
    };
  };
  nodes?: {
    account: Dictionary<AccountNodes> | {};
    issueFilters: NodesMap;
    issueList: NodesMap;
    issues: Dictionary<IssueNodes> | {};
  };
}

export interface CreateIssueBackendData {
  name: string;
  queueId: number;
  accountId: number;
  categoryId: number;
  workflowId: number;
  stateId: number;
  ownerId?: number;
  count?: number;
}

export interface CreateCaseIssueBackendData {
  name: string;
  queueId: number;
  accountId: number;
  categoryId: number;
  workflowId: number;
  stateId: number;
  ownerId?: number;
  count?: number;
}

export interface CreateOpportunityBackendData {
  name: string;
  accountId: number;
  opportunitySourceId: number;
  ownerId?: number;
  count?: number;
}

export enum IssueLinkRole {
  Unknown = 0,
  Related = 1,
  Blocked = 2,
  BlockedBy = 3,
  Parent = 5,
  Child = 4,
  Original = 6,
  Duplicate = 7,
}
