import { IssueType, ModuleName } from '../types';

type Id = number | string;

export interface Options {
  id: Id;
  typeId: IssueType;
  hash?: boolean;
}

const createIssueModuleLink = (id: Id, hash: boolean) =>
  `${hash ? '#' : ''}/${ModuleName.Issue}/${id}`;
const createTicketModuleLink = (id: Id, hash: boolean) =>
  `${hash ? '#' : ''}/${ModuleName.Ticket}/${id}`;
const createOpportunityModuleLink = (id: Id, hash: boolean) =>
  `${hash ? '#' : ''}/${ModuleName.Opportunities}/${id}`;

const ticketTypeIds: IssueType[] = [IssueType.Ticket, IssueType.Request];

export default ({ id, typeId, hash = true }: Options): string => {
  if (ticketTypeIds.includes(typeId)) {
    return createTicketModuleLink(id, Boolean(hash));
  }

  if (typeId === IssueType.Opportunities) {
    return createOpportunityModuleLink(id, Boolean(hash));
  }

  return createIssueModuleLink(id, Boolean(hash));
};
