const LIST_ISSUE_PATH = 'listIssues';

interface Data2PathObj {
  issueId?: number;
  accountId?: number;
  loadPossibleDuplicates?: boolean;
}

export const linkIssueKeys = [
  'subIssues',
  'blockedIssues',
  'blockedByIssues',
  'relatedIssues',
  'duplicateIssues',
  'originalIssues',
  'startrekIssues',
];

export const similarIssueKeys = ['possibleDuplicateIssues', 'similarIssues'];

const func = {
  listIssue() {
    return LIST_ISSUE_PATH;
  },
  subIssues(issueId: number) {
    return `issues.${issueId}.subIssues`;
  },
  blockedIssues(issueId: number) {
    return `issues.${issueId}.blockedIssues`;
  },
  blockedByIssues(issueId: number) {
    return `issues.${issueId}.blockedByIssues`;
  },
  relatedIssues(issueId: number) {
    return `issues.${issueId}.relatedIssues`;
  },
  duplicateIssues(issueId: number) {
    return `issues.${issueId}.duplicateIssues`;
  },
  originalIssues(issueId: number) {
    return `issues.${issueId}.originalIssues`;
  },
  startrekIssues(issueId: number) {
    return `issues.${issueId}.startrekIssues`;
  },
  possibleDuplicateIssues(issueId: number) {
    return `issues.${issueId}.possibleDuplicates`;
  },
  similarIssues(issueId: number) {
    return `issues.${issueId}.similarIssues`;
  },
  issueFilters() {
    return 'issueFilters';
  },
  accountIssue(accountId: number) {
    return `accounts.${accountId}.issues`;
  },
  data2Path(data: Data2PathObj = {}, issueId?: number) {
    let result = null;
    if (Object.prototype.hasOwnProperty.call(data, 'issueId')) {
      if (Object.prototype.hasOwnProperty.call(data, 'loadPossibleDuplicates')) {
        result = this.possibleDuplicateIssues(data.issueId);
      } else {
        result = this.subIssues(data.issueId);
      }
    } else if (Object.prototype.hasOwnProperty.call(data, 'accountId')) {
      result = this.accountIssue(data.accountId);
    } else {
      result = this.listIssue();
    }

    if (issueId != null) {
      result = this.merge(result, issueId);
    }

    return result;
  },
  merge(path, issueId) {
    return `${path}.map.${issueId}`;
  },
  isListIssuePath(path) {
    return path === LIST_ISSUE_PATH;
  },
};

export default func;
